BEGIN_SYMBOL_DEFINITIONS

 
  
   <!-- XPROJECT table -->
  COLS:XPROJECT=XPROJECT:*
  COLS:XPRJPRJCOLREL=XPRJPRJCOLREL:*
  COLS:XPRJCATREL=XPRJCATREL:*
  COLS:XPRJMTR=XPRJMTR:*
  COLS:XPRJINS=XPRJINS:*
  COLS:XPRJMTRCATREL=XPRJMTRCATREL:*  
  COLS:XPRJDES=XPRJDES:*
  COLS:XPRJMTRDES=XPRJMTRDES:*
  COLS:XPRJINSDES=XPRJINSDES:*


END_SYMBOL_DEFINITIONS
<!-- ====================================================================== 
	Get project description based on the project id 
	@param UniqueID The project id.	
=========================================================================== -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project[ProjectIdentifier[(UniqueID=)]]+MyCompany_ProjectDescription_Update
	base_table=XPRJDES
	sql=
		SELECT 
			XPRJDES.$COLS:XPRJDES$
	     	FROM	     			
	     		XPRJDES
	     	WHERE
	     		XPRJDES.XPROJECT_ID IN (?UniqueID?)
	     			
END_XPATH_TO_SQL_STATEMENT
<!-- ====================================================================== 
	Get project materials,material description,material related catentry based on the project id 
	@param UniqueID The project id.	
=========================================================================== -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project[ProjectIdentifier[(UniqueID=)]]+MyCompany_ProjectMaterial_Update
	base_table=XPRJMTR
	sql=
		SELECT 
			XPRJMTR.$COLS:XPRJMTR$,
			XPRJMTRDES.$COLS:XPRJMTRDES$,
			XPRJMTRCATREL.$COLS:XPRJMTRCATREL$

	     	FROM	     			
	     		XPRJMTR
			LEFT OUTER JOIN XPRJMTRDES ON
			XPRJMTR.XPRJMTR_ID = XPRJMTRDES.XPRJMTR_ID 
			LEFT OUTER JOIN  XPRJMTRCATREL ON
 			XPRJMTR.XPRJMTR_ID = XPRJMTRCATREL.XPRJMTR_ID AND XPRJMTRCATREL.STOREENT_ID IN ($CTX:STORE_ID$)

	     	WHERE
	     		XPRJMTR.XPROJECT_ID IN (?UniqueID?)
	     			
END_XPATH_TO_SQL_STATEMENT
<!-- ====================================================================== 
	Get project material description based on the material id 
	@param UniqueID The project id.	
=========================================================================== -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project[Material[ProjectMaterialIdentifier[(UniqueID=)]]]+MyCompany_ProjectMaterialDescription_Update
	base_table=XPRJMTRDES
	sql=
		SELECT 
			XPRJMTRDES.$COLS:XPRJMTRDES$
	     	FROM	     			
	     		XPRJMTRDES
	     	WHERE
	     		XPRJMTRDES.XPRJMTR_ID IN (?UniqueID?)
	     			
END_XPATH_TO_SQL_STATEMENT
<!-- ====================================================================== 
	Get project material catentry relation based on the material id 
	@param UniqueID The project id.	
=========================================================================== -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project[Material[ProjectMaterialIdentifier[(UniqueID=)]]]+MyCompany_ProjectMaterialCatentry_Update
	base_table=XPRJMTRCATREL
	sql=
		SELECT 
			XPRJMTRCATREL.$COLS:XPRJMTRCATREL$
	     	FROM	     			
	     		XPRJMTRCATREL
	     	WHERE
	     		XPRJMTRCATREL.XPRJMTR_ID IN (?UniqueID?)
	     			
END_XPATH_TO_SQL_STATEMENT
<!-- ====================================================================== 
	Get project instruction description based on the material id 
	@param UniqueID The project id.	
=========================================================================== -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project[Instruction[(UniqueID=)]]+MyCompany_ProjectInstructionDescription_Update
	base_table=XPRJINSDES
	sql=
		SELECT 
			XPRJINSDES.$COLS:XPRJINSDES$
	     	FROM	     			
	     		XPRJINSDES
	     	WHERE
	     		XPRJINSDES.XPRJINS_ID IN (?UniqueID?)
	     			
END_XPATH_TO_SQL_STATEMENT
<!-- ====================================================================== 
	Get project instruction,instruction description based on the project id 
	@param UniqueID The project id.	
=========================================================================== -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project[ProjectIdentifier[(UniqueID=)]]+MyCompany_ProjectInstruction_Update
	base_table=XPRJINS
	sql=
		SELECT 
			XPRJINS.$COLS:XPRJINS$,
			XPRJINSDES.$COLS:XPRJINSDES$

	     	FROM	     			
	     		XPRJINS 
			LEFT OUTER JOIN XPRJINSDES ON
			XPRJINS.XPRJINS_ID = XPRJINSDES.XPRJINS_ID

	     	WHERE
	     		XPRJINS.XPROJECT_ID IN (?UniqueID?)
	     			
END_XPATH_TO_SQL_STATEMENT
<!-- ====================================================================== 
	Get project related catentry based on the project id 
	@param UniqueID The project id.	
=========================================================================== -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project[ProjectIdentifier[(UniqueID=)]]+MyCompany_ProjectTool_Update
	base_table=XPRJCATREL
	sql=
		SELECT 
			XPRJCATREL.$COLS:XPRJCATREL$
	     	FROM	     			
	     		XPRJCATREL
	     	WHERE
	     		XPRJCATREL.XPROJECT_ID IN (?UniqueID?)
	     			
END_XPATH_TO_SQL_STATEMENT
<!-- ====================================================================== 
	Get project related collection based on the project id 
	@param UniqueID The project id.	
=========================================================================== -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project[ProjectIdentifier[(UniqueID=)]]+MyCompany_ProjectPrjColRel_Update
	base_table=XPRJPRJCOLREL
	sql=
		SELECT 
			XPRJPRJCOLREL.$COLS:XPRJPRJCOLREL$
	     	FROM	     			
	     		XPRJPRJCOLREL
	     	WHERE
	     		XPRJPRJCOLREL.XPROJECT_ID IN (?UniqueID?)
	     			
END_XPATH_TO_SQL_STATEMENT


<!-- ====================================================================== 
	Get project  based on the project id 
	@param UniqueID The project id.	
=========================================================================== -->

BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project[ProjectIdentifier[(UniqueID=)]]+MyCompany_Project_Update
	base_table=XPROJECT
	sql=
		SELECT
			XPROJECT.$COLS:XPROJECT$
							
	     	FROM	     			
	     		XPROJECT 
	     	WHERE
	     		XPROJECT.XPROJECT_ID IN (?UniqueID?)	     			
	     			
END_XPATH_TO_SQL_STATEMENT

<!-- ====================================================================== 
	Get project  based on the project name
	@param UniqueID The project name.	
=========================================================================== -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project[ProjectIdentifier[ExternalIdentifier[(Name=)]]]+MyCompany_IdResolve
	base_table=XPROJECT
	sql=
		SELECT 
			XPROJECT.$COLS:XPROJECT$
							
	     	FROM	     			
	     		XPROJECT 
	     	WHERE
	     		XPROJECT.PRJNAME IN (?Name?)	     			
	     			
END_XPATH_TO_SQL_STATEMENT



